package com.ejie.ab04b.control;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.CierreMasivo;
import com.ejie.ab04b.model.TramiteAperturas;
import com.ejie.ab04b.service.CierreMasivoService;
import com.ejie.ab04b.util.ManejoSesion;
import com.ejie.ab04b.util.PropertiesUtil;
import com.ejie.ab04b.util.UtilidadesWar;
import com.ejie.ab04b.util.Utilities;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * CierreMasivoController NO generated by UDA, 21-ago-2017
 * 
 * @author NO UDA
 */

@Controller()
@RequestMapping(value = "/cierreMasivo")
public class CierreMasivoController {

	private static final Logger logger = LoggerFactory
			.getLogger(CierreMasivoController.class);

	private static final String PARAM_SESSION_FILTER_FORM = "sessionFilterForm";
	private static final String PARAM_URL_ENVIO = "urlEnvio";

	@Autowired()
	private CierreMasivoService cierremasivoService;

	@Autowired()
	private ReloadableResourceBundleMessageSource messageSource;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 *  binder
	 *            WebDataBinder
	 *
	 * @param binder the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class, new CustomDateEditor(
				dateFormat, true));
	}

	/*
	 * OPERACIONES CRUD (Read)
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 *  model
	 *            Model
	 *  request
	 *            HttpServletRequest
	 *  borrar
	 *            the borrar
	 *  loadFilter
	 *            String
	 *
	 * @param model the model
	 * @param request the request
	 * @param borrar the borrar
	 * @param loadFilter the load filter
	 *  String
	 * @return the form edit
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model, HttpServletRequest request,
			@RequestParam(required = false) boolean borrar,
			@RequestParam(value = "f", required = false) String loadFilter) {
		CierreMasivoController.logger.info("[GET - View] : cierremasivo");

		String codDel = UtilSeguridad.getInstance().obtenerDelegacionUsuario();
		CierreMasivo filterForm = new CierreMasivo();
		if (loadFilter != null && Boolean.valueOf(loadFilter)) {
			// pasamos filtro a model
			model.addAttribute(
					CierreMasivoController.PARAM_SESSION_FILTER_FORM,
					ManejoSesion.pasaDatosNavegacionModel(request, model,
							CierreMasivo.class));
		} else {
			if (!codDel.equals(Constantes.DEL_LAKUA)) {

				filterForm.setTerritorioExpediente077(codDel);
			}
			model.addAttribute(
					CierreMasivoController.PARAM_SESSION_FILTER_FORM,
					filterForm);
		}
		this.precargaCombosFiltroBusqueda(model);
		model.addAttribute(
				CierreMasivoController.PARAM_URL_ENVIO,
				PropertiesUtil
						.getProperty(PropertiesUtil.GESTION_ENVIOS_URL_AA66_ENVIO));

		model.addAttribute(CierreMasivoController.PARAM_SESSION_FILTER_FORM,
				filterForm);

		model.addAttribute("borrar", borrar);

		return "cierremasivo";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 *  filterCierreMasivo
	 *            CierreMasivo Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *  request
	 *            HttpServletRequest
	 *
	 * @param filterCierreMasivo the filter cierre masivo
	 * @param jqGridRequestDto the jq grid request dto
	 * @param request the request
	 *  JQGridResponseDto<CierreMasivo> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody()
	JQGridResponseDto<CierreMasivo> filter(
			@RequestJsonBody(param = "filter") CierreMasivo filterCierreMasivo,
			@RequestJsonBody() JQGridRequestDto jqGridRequestDto,
			HttpServletRequest request) {
		CierreMasivoController.logger
				.info("[POST - filter] : Obtener TramiteAperturas");

		CierreMasivo filterCierreMasivoAux = filterCierreMasivo;
		Object datosFiltroSesion = ManejoSesion.recuperaDatosFiltro(request,
				jqGridRequestDto, TramiteAperturas.class);

		if (datosFiltroSesion != null) {
			filterCierreMasivoAux = (CierreMasivo) datosFiltroSesion;
		} else {
			// guarda filtro
			ManejoSesion.guardaFiltro(request, filterCierreMasivoAux,
					jqGridRequestDto);
		}

		return this.cierremasivoService.findCierreMasivo(filterCierreMasivoAux,
				jqGridRequestDto);
	}

	/**
	 * Realiza la exportaciÃ³n a Excel.
	 * 
	 *  filterCierreMasivo
	 *            Expediente Bean que contiene los parÃ¡metros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto
	 *            JQGridRequestDto que contiene los parÃ¡mtros de configuraciÃ³n
	 *            propios del RUP_TABLE a aplicar en el filtrado.
	 *  modelMap
	 *            ModelMap
	 *  columns
	 *            String
	 *  request
	 *            HttpServletRequest
	 *
	 * @param filterCierreMasivo the filter cierre masivo
	 * @param jqGridRequestDto the jq grid request dto
	 * @param modelMap the model map
	 * @param columns the columns
	 * @param request the request
	 *  ModelAndView
	 * @return the report
	 */
	@RequestMapping(value = { "xlsReport", "xlsxReport" }, method = RequestMethod.POST)
	protected ModelAndView getReport(
			@ModelAttribute() CierreMasivo filterCierreMasivo,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns,
			HttpServletRequest request) {

		// Limpiamos los datos de paginacion para mostrar todos los registros
		jqGridRequestDto.setPage(null);
		jqGridRequestDto.setRows(null);

		// Acceso a BD para recuperar datos
		List<CierreMasivo> listCierreMasivo = this.cierremasivoService
				.findListCierreMasivo(filterCierreMasivo, jqGridRequestDto);
		// GENERAMOS EL FICHERO
		UtilidadesWar.generateReport(modelMap, Utilities.getLiteralMessage(
				this.messageSource, "excel.titulo.cierreMasivo"), columns,
				listCierreMasivo);

		// Generacion del XLS o XLSX
		if (request.getServletPath().indexOf("xlsReport") != -1) {
			return new ModelAndView("xlsReport", modelMap);
		} else {
			return new ModelAndView("xlsxReport", modelMap);
		}
	}

	/**
	 * Anade al model los datos necesarios para la carga de los combos de la
	 * pantalla del filtro de busqueda.
	 * 
	 *  model
	 *            Model
	 *
	 * @param model the model
	 */
	private void precargaCombosFiltroBusqueda(Model model) {

		model.addAttribute("autoridades", UtilSeguridad.getInstance()
				.obtenerDelegacionesUsuario());

		// tipo identificacion
		model.addAttribute("tipoidentificacion", Constantes.COMBO_TIPO_IDENTIF);

	}
}
